macroScript Skin2Physique
	category:"monsterBlues"
	buttontext:"Skin 2 Physique"
	tooltip:"Skin2Physique and Back"

(

	global TRI_Tools
	global TRI_Anim

------------------------------------
-- CREATES DIALOG AND KILLS EXISTING
------------------------------------

	if TRI_Tools != undefined do	( closerolloutfloater TRI_Tools )
	TRI_Tools = newrolloutfloater "ES Tools" 190 250
	
--****************************
-- ANIM TOOL GO!!!!!!!!!
--****************************

rollout TRIphytools "Ferril Tools"
(
	group "PhyTools"
	(
		button savePhy "Save Selected Vertices" across:2 align:#left
		button savePhyHelp "?" align:#right
		button loadPhyData "Load the Physque Data" across:2 align:#left
		button loadPhyDataHelp "?" align:#right
	)

	group "SkinTools"
	(
		button saveSkin "Save Selected Vertices" across:2 align:#left
		button saveSkinHelp "?" align:#right
		button loadSkinData "Load the Skin Data" across:2 align:#left
		button loadSkinDataHelp "?" align:#right		
		button Extract "Bake Skin to a mesh" across:2 align:#left
		button ExtractHelp "?" align:#right
		button ImportWts "Import Skin Weights" across:2 align:#left
		button ImportWtsHelp "?" align:#right
	)
	
	on savePhyHelp pressed do messagebox "This button will save the PHYSIQUE weights on selected vertices to an external temp file.\n\n1. Select only the vertices you want to save in Editable_Poly or Editable mesh mode (NOT physique mode!)\n2. Then hit the button.\n3. You can load the weights onto PHYSIQUE or SKIN." Title:"Help"
	on loadPhyDataHelp pressed do messagebox  "Select a model with a PHYSIQUE modifier to load the saved weights.\n\n1. Select your model.\n2. De-activate duplicate links.\n3. You DO NOT need to be in sub-object mode.\n4. Hit the button, verts will load rigid (green) no matter how they were saved." Title:"Help"
	on saveSkinHelp pressed do messagebox "This button will save the SKIN weights on selected vertices to an external temp file.\n\n1. Select only the vertices you want to save in Editable_Poly or Editable mesh mode (NOT skin mode!)\n2. Then hit the button.\n3. You can load the weights onto PHYSIQUE or SKIN." Title:"Help"
	on loadSkinDataHelp pressed do messagebox  "Select a model with a SKIN modifier to load the saved weights.\n\n1. Select your model.\n2. You DO NOT need to be in sub-object mode." Title:"Help"
	on ExtractHelp pressed do messagebox  "This will save a baked version of your mesh with the vertex weight data.\nYou can load them later on a model with modified geometry.\n\n1. Select a weighted model with a SKIN modifier.\n2. If your model has PHYSIQUE use the conversion tool to change it to SKIN.\n3. Press the button to bake weights.\n4. DO NOT change the name of the baked mesh." Title:"Help"
	on ImportWtsHelp pressed do messagebox  "This will import the vertex weighting of a baked mesh to a mesh with a skin modifer.\n\n1. Add a SKIN modifer to your model.\n2. In the SKIN rollout Add the bones to the model.\n3. Select both the baked model and the unweighted model.\n4. Hit the button.\n5. In the import dialog hit Match By Name.\n6. Then hit OK.\n7. Test to see if the weights loaded correctly.\n8. If it failed try to Reset X-forms on both models." Title:"Help"

	on savePhy pressed do
	(
		if $ != undefined then
		(
			if selection.count == 1 then
			(
				msfilename = "$temp\\ferril2.ms"
				createms = createfile msfilename
				openfile msfilename
				if filters.Is_EditPoly() then
					sel = polyOp.getVertSelection $
				else sel = sel = getVertSelection $
				
				for v in sel do
				(		
					weightArray = #()
					_boneArray = #()

					for b = 1 to physiqueOps.getVertexBoneCount $ v do
					(
							_bone = physiqueOps.getVertexBone $ v b
							_bone = "$'" + _bone.name + "'"	
							weight = physiqueOps.getVertexWeight $ v b
							append weightArray weight
							append _boneArray _bone

							if b == physiqueOps.getVertexBoneCount $ v do
							(
								format "%\n" v to:createms
								format "%\n" weightArray to:createms
								format "%\n" _boneArray to:createms
							)
					)
				)
				close
				messagebox "Saved selected vertex weights to a temp file." Title:"Saved"
			)
			else messagebox "Please select vertices in one object only!" Title:"Error"
		)
		else messagebox "Please select an object." Title:"Error"
	)
	
	on loadPhyData pressed do
	(
		if $ != undefined then
		(
			if selection.count == 1 then
			(
				--Load the Data
				msfilename = "$temp\\ferril2.ms"
				cf = openfile msfilename	
			
				while eof cf == false do 
				(
					a = readline cf
					b = readline cf
					c = readline cf	

					Vert = execute(a)
					WeightsArray = execute(b)
					BonesArray = execute(c)
						
					--Clear the weights (This is Physique specific)
					physiqueops.setvertexbone $ Vert (execute(BonesArray[1])) clear:true weight:0
					
					--Now Load the weights
					for i = 1 to BonesArray.count do
					(
						physiqueops.setvertexbone $ Vert (execute(BonesArray[i])) weight:WeightsArray[i]			
					)
				)-- End of While

				close
				messagebox "Loaded vertex weights from temp file." Title:"Loaded"
				slidertime = slidertime + 1
				slidertime = slidertime - 1
				max views redraw
			)
			else messagebox "Please select one object to load the saved weights!" Title:"Error"
		)
		else messagebox "Please select an object." Title:"Error"
	)
	
	on saveSkin pressed do
	(
		if $ != undefined then
		(
			if selection.count == 1 then
			(
				subobjectlevel = 0
				msfilename = "$temp\\ferril2.ms"
				createms = createfile msfilename
				openfile msfilename
				if filters.Is_EditPoly() then
					sel = polyOp.getVertSelection $
				else sel = getVertSelection $
				
				modPanel.setCurrentObject $.skin
				
				for v in sel do
				(
					weights = #()
					_bones = #()
		
					for b = 1 to skinOps.GetVertexWeightCount $.skin v do
					(
						weight = skinOps.GetVertexWeight $.skin v b
						_boneID = skinOps.GetVertexWeightBoneID $.skin v b
						_bone = skinOps.GetBoneName $.skin _boneID 1
						_bone = "$'" + _bone + "'"	
							
						if weight != 0 then
							(
							append weights weight
							append _bones _bone
							)
						else continue
					)
					
					format "%\n" v to:createms
					format "%\n" weights to:createms
					format "%\n" _bones to:createms
				)
				
				close
				messagebox "Saved selected vertex weights to a temp file." Title:"Saved"
			)
			else messagebox "Please select vertices in one object only!" Title:"Error"
		)
		else messagebox "Please select an object." Title:"Error"
	)
	
	on loadSkinData pressed do
	(
		if $ != undefined then
		(
			if selection.count == 1 then
			(
				msfilename = "$temp\\ferril2.ms"
				cf = openfile msfilename	
				struct stWeights (vt,bone)		
				local varray = #()

				NameArray = #()
				NumBones = skinOps.GetNumberBones $.skin
				for nb = 1 to NumBones do
				(
					BoneName = skinOps.GetBoneName $.skin nb 0
					BoneName = "$'" + BoneName + "'"
					append NameArray BoneName
				)
				
				msfilename = "$temp\\ferril2.ms"
				cf = openfile msfilename

				while eof cf == false do 
				(
					boneIDarray = #()
					
					a = execute(readline cf)
					b = execute(readline cf)
					c = execute(readline cf)
					
					for i = 1 to c.count do
						(
							BoneID = findItem NameArray c[i]
							append boneIDarray BoneID
						)
						
					skinOps.ReplaceVertexWeights $.skin a boneIDarray b
					
				)-- End of While
				
				close cf
			)
			else messagebox "Please select vertices in one object only!" Title:"Error"
		)
		else messagebox "Please select an object." Title:"Error"
	)
	
	on Extract pressed do
	(
		try(skinUtils.ExtractSkinData $)catch(messagebox "You must select a model with a Skin modifier." Title:"Error")
	)
	
	on ImportWts pressed do
	(
		if $.count == 2 do
		(
			if matchpattern $[1].name pattern:"SkinData" then
				skinUtils.ImportSkinData $[2] $[1]
			else skinUtils.ImportSkinData $[1] $[2]
		)
	)

)
	
	addRollout TRIphytools TRI_Tools
)